local assets =
{
	Asset("ANIM", "anim/garbage.zip"),
    Asset("ATLAS", "images/inventoryimages/garbage.xml"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("garbage")
    inst.AnimState:SetBuild("garbage")
    inst.AnimState:PlayAnimation("BUILD")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("fillable")
    inst.components.fillable.filledprefab = "spidergland"
	inst:AddComponent("stackable")
	inst:AddComponent("tradable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "garbage"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/garbage.xml"
    inst:AddComponent("selfstacker")

    MakeHauntableLaunchAndSmash(inst)

    return inst
end

return Prefab("garbage", fn, assets)